	function Att = PZ_2_ATT_S(G, Z, P, W)
	
	%	Computes the attenuation for an analog filter significantly 
	% 	more accurate than the standard MATLAB routine freqs.
 
	% 	Replaces the MATLAB routine freqs
 
	% 	Toolbox for  DIGITAL FILTERS USING MATLA

	% 	Author: 		Lars Wanhammar, 2007-02-19
	% 	Modified by: 		
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com

		H = G*ones(1,length(W));
		W = i*W;
		for n = 1:length(Z)
			H = H.*(W - Z(n));    
		end
		for n = 1:length(P)
			H = H./(W - P(n));    
		end
		Att = MAG_2_ATT(H);
